// Copyright (c) Pablo Halpern, 1999.
// Permission is hereby granted to use, modify and redistribute this
// code freely.
//
// Bug work-around for egcs 1.1.2 string implementation.
// Bug: The implementation of the stream output operator (operator <<)
// for std::string does not honor the width and adjustment format flags.
// This file works around this bug. It must be included before the <string>.
// One way to ensure this without modifying source code is to use
// the --include stringiofixes.h compiler option.

#ifndef stringiofixes_dot_h
#define stringiofixes_dot_h 1

// Change behavior of ostream << string to honor the alignment and width
// format parameters.

// This is a terible hack and only works for the specific definitions
// in egcs 1.1.2 (may also work for gnu 2.95).

// By aliasing ostream, we stop the declaration of operator<<(ostream, string).
// (Instead, operator<<_ostream_dummy, string) is declared and not used.)
#define ostream _ostream_dummy
#include <string>
#undef ostream

class ostream;

// Now we define the real, inlined version of operator<<
template <class charT, class traits, class Allocator> inline ostream&
operator<< (ostream& os, const basic_string <charT, traits, Allocator>& s)
{
  return os << s.c_str();
}

#endif /* stringiofixes_dot_h */
