#ifndef INET_H
#define INET_H  1


/*! \addtogroup INET */
/*! @{ */


/* ========================================================================== */
/* Constants */

/*! \name Error codes */
/*! @{ */
#define INET_ERR_UNSPEC  -1  /*!< \brief Unspecified error */
#define INET_ERR_HNR     -2  /*!< \brief Host name resolution failed */
#define INET_ERR_SNR     -3  /*!< \brief Service name resolution failed */
#define INET_ERR_AF      -4  /*!< \brief Address family not supported */
#define INET_ERR_SOCK    -5  /*!< \brief Socket creation failed */
#define INET_ERR_CONN    -6  /*!< \brief Connection failed */
#define INET_ERR_BADF    -7  /*!< \brief Invalid socket descriptor */
#define INET_ERR_RX_TO   -8  /*!< \brief Setting RX timeout failed */
#define INET_ERR_TX_TO   -9  /*!< \brief Setting TX timeout failed */
/*! @} */


/* ========================================================================== */
/* Variables */

extern int  inet_force_ipv4;


/*! @} */


/* ========================================================================== */
/* Function prototypes */

int  inet_connect(int*, int*, const char*, const char*);
int  inet_set_rx_timeout(int, unsigned int);
int  inet_set_tx_timeout(int, unsigned int);
void  inet_close(int*);


#endif  /* INET_H */

/* EOF */
