# ==============================================================================
# Maintain NLS translation files
#
# Copyright (c) 2012-2013 by the developers. See the LICENSE file for details.
#
# Remove strings that are no longer used and add new strings to translation file


# ==============================================================================
# Generate header of NLS message file

BEGIN \
{
   # Get name of translation file
   fn = ENVIRON["NLS_TRANSLATION"]
   if("" == fn)  exit(1)
}


# ==============================================================================
# Copy comments starting with "$ "

/^\$[ ]/ \
{
   print
   next
}


# ==============================================================================
# Copy empty lines

/^$/ \
{
   print
   next
}



# ==============================================================================
# Search every string from table in translation file and create NLS message

{
   if(match($0, /^".*"/))
   {
      # Original (not translated) string found
      orig = substr($0, RSTART, RLENGTH)
      transl = search_translation(orig)
      if (transl != orig)
      {
         printf("%s %s\n", orig, transl)
      }
      else
      {
         printf("%s\n", orig)
      }
   }
   next
}


# ==============================================================================
# Search translation for string 's'
# The parameter 's' is returned if nothing was found

function search_translation(s) \
{
   # Open file
   if(-1 == getline cur <fn)  exit(1)

   # Search string
   do
   {
      if(match(cur, /^"[^"]*"/))
      {
         # String found => Check whether it is the searched one
         if(substr(cur, RSTART, RLENGTH) == s)
         {
            # Yes => Extract translation
            tl = substr(cur, RSTART + RLENGTH)
            if(match(tl, /".*"/))
            {
               translation = substr(tl, RSTART, RLENGTH)
               if(close(fn))  exit(1)

               # Return translated string
               return(translation)
            }
         }
      }
   }
   while(1 == getline cur <fn)

   # Translation not found
   # Close file
   if(close(fn))  exit(1)
   # Return original string
   return(s)
}


# EOF
